SELECT tsystem.function__drop_by_regex('abk__termination_execute__auto', 'scheduling', true, true);
CREATE OR REPLACE FUNCTION scheduling.abk__termination_execute__auto(
    IN  _ab_ix                                    integer,
        -- Mittelpunktterminierung, ab diesem AG (Vorwärts / Rückwärts). Standard: NULL (vorwärts/rückwärts alles)
    IN  _a2_n__middle                             integer, -- Innerhalb der AG Grenzen Mittelpunkt in Richtung der Terminierung ab hier
        -- Startpunkt der Terminierung für Mittelpunktterminierung
    IN  _date_start                               timestamp,
        -- Ergbnis nur als Vorschau? -> Rückgabe der Funktion
    IN  _write_to_disk                            bool      = false,-- NOT NULL,
        -- Terminierungsrichtung / Art
    IN  _forward__backward__middle__null_auto     varchar   = NULL,
        -- Zeitfenster
    IN  _range_years                              numeric   = 1.5,
        -- Wenn Rückwärtsterminierung in Vergangenheit kommt, dann automatisch Vorwärtsterminerung
    IN  _AutoForwardOnPast                        bool      = true,
    IN  _a2_n__start                              integer   = NULL,
    IN  _a2_n__stop                               integer   = NULL,
    IN  _current_date                             timestamp = now(),
    IN  _dlz_terminiation                         bool      = false,
    IN  _allow_overlap                            bool      = false,
        -- nur in Kombination Overlap: wenn durch Overlag ein Folge-AG berührt wird, dann diese im Anschluss auch weiterterminieren!
    IN  _allow_overlap__following_if_necessary    bool      = false,
        -- wenn bereits einterminiert, dann diese Resource erhalten!
    IN  _resource_id_main_fix__clear              bool      = false,
        -- Chooser neu starten. Sonst bleibt es auf der terminierten Resource!
    IN  _stack_depth                              int       = 0,
    IN  _loglevel                                 int       = TSystem.Log_Get_LogLevel( _user => 'yes' ),
    OUT ti_resource_id                            integer,
    OUT ti_a2_id                                  integer,
    OUT ti_date_start                             timestamp without time zone,
    OUT ti_date_end                               timestamp without time zone,
    OUT slotfactor                                numeric,
    OUT ti_type                                   scheduling.resource_timeline_blocktype,
    OUT ksv__is_top_ksv                           bool,
    -- true, wenn timeslot hier durch terminierung erstellt wurde. false, wenn bestehender timeslot (zB nur AG 50 terminieren, dennoch werden die anderen AG mit ausgegeben, siehe "IF termination_successfull THEN ")
    OUT timeslot_terminated                       bool,
    OUT stat                                      text,
    OUT debughint                                 text
    --  _frozen_range integer DEFAULT *********************  232436  *******************
    )
    RETURNS SETOF record
        -- RETURNS SETOF scheduling.resource_timeline__abk_ab2__termination
        -- RETURNS TABLE(__resource_id integer, __ab2_id integer, __slotstartdate timestamp without time zone, __slotenddate timestamp without time zone, __slotfactor numeric, __type scheduling.resource_timeline_blocktype)
    AS $$
    DECLARE
         _timeframe_start                             timestamp without time zone;
         _timeframe_end                               timestamp without time zone;
         _termination_start__middle                   timestamp;

         max_ti_date_end                              timestamp;
         _result_within_abk                           timestamp;
         _result_within_resource                      timestamp;
         _result_within_all                           timestamp;

         -- Mittelpunktterminierung: ab diesem AG
         _termination_middle__a2_id                   integer;
         -- Teilweise Terminieren: ab diesem AG
         _termination_range__a2_id__start             integer;
         -- Teilweise Terminieren: bis zu diesem AG
         _termination_range__a2_id__stop              integer;
         --
         _packing                                     bool;
         _following_ab2_arr                           int[];
         _following_ab2_arr__done                     int[];
         --
         r                                            record;
         --
         termination_successfull                      bool;
         temp_int                                     integer;
         --
         s                                            text; -- Debug Text für Ausgabe (Hints/Raise Notices)
         d                                            timestamp;
     BEGIN

         IF _stack_depth <= 0 THEN  -- DROP/RECREATE TABLE IF EXISTS existing_rt;
           --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
           --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
           --  KEIN RETURN IM CODE OHNE ENABLE!!!
           PERFORM disablebedarfberech();
           --- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

          
          SET client_min_messages = warning; -- hide notice already exists

          -- DROP TABLE IF EXISTS existing_rt; nur wenn im laufenden Betrieb Strukturänderungen und bereits TEMP TABLE noch vorhanden war.

          CREATE TEMP TABLE IF NOT EXISTS existing_rt AS
                             SELECT rt.ti_resource_id AS __resource_id,
                                    rt.ti_a2_id       AS __ab2_id,
                                    null::integer     AS __ab_ix,
                                    rt.ti_date_start  AS __slotstartdate,
                                    rt.ti_date_end    AS __slotenddate,
                                    rt.ti_ta_kf       AS __slotfactor,
                                    rt.ti_type        AS __type,
                                    null::bool        AS __ksv__is_top_ksv,
                                    false             AS __timeslot_terminated,
                                    null::text        AS __stat,
                                    null::text        AS __debughint,
                                    _stack_depth      AS __stack_depth
                               FROM scheduling.resource_timeline rt
                              LIMIT 0;
          TRUNCATE existing_rt;
        END IF;

        SET client_min_messages = notice;

        IF _stack_depth > 50 THEN
           RAISE EXCEPTION 'abk__termination_execute__auto: stack_depth > 50: ix=%', _ab_ix
           RETURN;
        END IF;

        -- Packen (Vorwärts, dann vom Zieldatum rückwärts um zu Packen) im Standard mit False initialisieren. Wird durch Logik oder Eingangsparameter "forward-pack" auf true gesetzt
        _packing                    := false;

        s := format('SELECT scheduling.abk__termination_execute__auto('||E'\r\n'||
                    '     _ab_ix => %s '||E'\r\n'||
                    '    ,_a2_n__middle => %s '||E'\r\n'||
                    '    ,_date_start => ''%s'' '||E'\r\n'||
                    '    -- ,_write_to_disk => %s -- warning false currently clear termination despite it'||E'\r\n'|| -- zum rauskopieren default false.
                    '    ,_forward__backward__middle__null_auto => ''%s'' '||E'\r\n'||
                    '    ,_range_years => %s '||E'\r\n'||
                    '    ,_AutoForwardOnPast => %s '||E'\r\n'||
                    '    ,_a2_n__start => %s '||E'\r\n'||
                    '    ,_a2_n__stop => %s '||E'\r\n'||
                    '    ,_current_date => ''%s'' '||E'\r\n'||
                    '    ,_dlz_terminiation => %s '||E'\r\n'||
                    '    ,_allow_overlap /*(overwritte by _allow_overlap__following_if_necessary)*/ => %s '||E'\r\n'||
                    '    ,_allow_overlap__following_if_necessary => %s '||E'\r\n'||
                    '    ,_resource_id_main_fix__clear => %s '||E'\r\n'||
                    '    ,_loglevel => %s )',

                    _ab_ix,
                    _a2_n__middle,
                    _date_start,
                    _write_to_disk::varchar,
                    _forward__backward__middle__null_auto,
                    _range_years,
                    _AutoForwardOnPast::varchar,
                    _a2_n__start,
                    _a2_n__stop,
                    _current_date,
                    _dlz_terminiation::varchar,
                    _allow_overlap::varchar,
                    _allow_overlap__following_if_necessary::varchar,
                    _resource_id_main_fix__clear::varchar,
                    _loglevel::varchar
                    )
                    ;
        RAISE NOTICE '%=>%', clock_timestamp()::time, s;

        -- Start/Ende AG sowie Mittelpunktterminierung: Sinnvoll mit 0en und Variablen befüllen
            _a2_n__middle          := nullif(_a2_n__middle, 0);
            _a2_n__start           := nullif(_a2_n__start, 0);
            _a2_n__stop            := nullif(_a2_n__stop, 0);
            -- Wenn Start = Anfang oder Ende ist es logischerweise KEINE Mittelpunktterminierung!
            -- Bei Start = Ende kann es noch Folge bei Bedarf geben.
            _a2_n__middle          := nullif(_a2_n__middle, _a2_n__start);
            IF NOT _allow_overlap__following_if_necessary THEN
              _a2_n__middle          := nullif(_a2_n__middle, _a2_n__stop);
            END IF;
        --

        -- WENN Vorwärtsterminieren und FOLGE AG s BEI BEDARF weiterschieben DANN erstmal Ende=Anfang damit nicht alle folgenden austerminiert werden! [_a2_n__start, _a2_n__stop]
          IF _allow_overlap__following_if_necessary THEN
             IF _forward__backward__middle__null_auto  <> 'forward' THEN
                 RAISE EXCEPTION '_allow_overlap__following_if_necessary ONLY IMPLEMENTED forward: NOT YET IMPLEMENTED, TODO! >>%<<', _forward__backward__middle__null_auto;
             END IF;

             -- Ende = Anfangs AG
             -- Terminieren mit Overlap
             -- Wenn Ergebnis > AT Folge AG, dann diesen wieder aufrufen
             _a2_n__stop := coalesce(_a2_n__stop, _a2_n__start, _a2_n__middle);
             -- TODO bisherigen STOP merken!
          END IF;
        --
        _termination_middle__a2_id                    := a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix AND a2_n = _a2_n__middle;

        -- RAISE NOTICE '_termination_middle__a2_id => %;  ix:%, a2n:%', _termination_middle__a2_id, _ab_ix, _a2_n__middle;

        -- Terminierung Grenzen AG von bis [_a2_n__start, _a2_n__stop]
            IF _a2_n__start IS NOT NULL THEN
               _termination_range__a2_id__start       := a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix AND a2_n >= _a2_n__start ORDER BY a2_n LIMIT 1; -- ORDER BY a2_n LIMIT: bei Mittelpunkt wird Vor-AG + 1 übergeben. zB Vor AG 30 ist terminiert, somit bis 31. Somit der nächste ab 31.
            END IF;

            -- Wenn Anfang und kein Ende, oder Ende
            IF    _a2_n__start IS NOT NULL -- ??
               OR _a2_n__stop  IS NOT NULL
            THEN
                 -- Bis zu AG. Ist keiner angegeben, dann bis zum Letzten.
                 _termination_range__a2_id__stop      := a2_id FROM ab2 WHERE a2_ab_ix = _ab_ix AND a2_n <= coalesce(_a2_n__stop, 9999999999) ORDER BY a2_n DESC LIMIT 1;

                 -- TODO: bis zum ersten, wenn Richtung rückwärts angegeben. Klärung: Rückwärts knallt, vorwärts, was dann?
            END IF;
        --

        -- *** DATUM *** Ermittlung des Zieldatum der Terminierung auf Basis von vorwärts/rückwärts/automatisch usw. Timeframe Start/Ende, packing etc
            -- wenn keine Richtung, dann automatisch ermitteln anhand Zieldatum
            IF _forward__backward__middle__null_auto IS NULL THEN
               IF coalesce(_termination_middle__a2_id, _termination_range__a2_id__start, _termination_range__a2_id__stop) IS NOT NULL THEN
                   RAISE EXCEPTION 'no direction defined, but operation borders defined. cannot schedule without direction. Terminierung mit Angabe von AG nur möglich, wenn eine Richtung vorgegeben';
               END IF;

               --
               IF _date_start > _current_date + interval '90 days' THEN -- => 90 auch in Oberfläche!
                  _forward__backward__middle__null_auto  := 'backward';
               ELSE
                  -- Automatik UND Zieltermin innerhalb der nächsten 30 Tage. Dann ab heute.
                  -- Sonst würde zB vorwärts ab nächste Woche terminiert, obwohl nächste Woche Zieltermin wäre.
                  _date_start                            := timediff_adddays(_current_date::date, 14, true, true); -- + frozen;
                  _forward__backward__middle__null_auto  := 'forward-pack';
               END IF;
            END IF;

            -- Anhand Richtung die Terminierungsfunktion richtige Datumsgrenzen
            -- ACHTUNG auch in: abk__termination_group_execute
            -- Rückwärts: Beginnt am Ende. Max bis heute.
            d := null;
            IF _forward__backward__middle__null_auto      = 'backward' THEN
               IF NOT _allow_overlap AND _allow_overlap__following_if_necessary THEN -- initialer AG soll seine angrenzenden beachten! Dann je nach Richtung korrekt setzen!
                   -- hier ist immer ein initialer AG gesetzt!
                   d := (scheduling.ab2__next__terminated__get(_termination_range__a2_id__start)).a2_at; -- Start FolgeAG ist meine Grenze
                   IF d IS NOT null AND d < _date_start THEN
                       _date_start := d;
                   END IF;
               END IF;
               _timeframe_start                          := greatest(_current_date, _date_start::date - round( _range_years * 365)::integer ); -- + frozen;
               _timeframe_end                            := _date_start;
            END IF;

            -- Vorwärts: Beginnt heute. Max bis Range.
            IF _forward__backward__middle__null_auto LIKE 'forward%' THEN
               IF NOT _allow_overlap AND _allow_overlap__following_if_necessary THEN -- initialer AG soll seine angrenzenden beachten! Dann je nach Richtung korrekt setzen!
                   -- hier ist immer ein initialer AG gesetzt!
                   d := (scheduling.ab2__prior__terminated__get(_termination_range__a2_id__start)).a2_et; -- Ende Vorarbeitsgang ist meine Grenze
                   IF d IS NOT null AND d > _date_start THEN
                       _date_start := d;
                   END IF;
               END IF;
               _timeframe_start                          := greatest(_current_date, _date_start ) ; -- Beschaffungsfrist Material! -- TSystem.Settings__GetInteger('abk_term_sperrange_days') => Oberfläche?
               _timeframe_end                            := _timeframe_start::date + round( _range_years * 365)::integer;
               _packing                                  := _forward__backward__middle__null_auto = 'forward-pack'
                                                            -- Wenn Start AG = Ende AG kann es keinen Unterschied vorwärts/rückwärts geben!
                                                            AND NOT ( coalesce( _a2_n__start = _a2_n__stop, false ) );
               _forward__backward__middle__null_auto     := 'forward';
            END IF;

            -- Mittelpunktterminierung: Zeitfenster ist vom Terminierungsstart aus gesehen davor und dahint.
            IF _termination_middle__a2_id IS NOT null THEN
                -- Startzeitpunkt der Mittelpunktterminierung
                _termination_start__middle               := _date_start;
                --
                _timeframe_start := _current_date; -- Bei Mittelpunktterminierung darf bis dahin dann rückwärts terminiert werden!
                RAISE NOTICE 'scheduler__abk__termination_execute__auto _termination_middle__a2_id : %, _termination_range__a2_id__start : %, _termination_range__a2_id__stop : % timeframe: %, %',
                                     _termination_middle__a2_id,
                                     _termination_range__a2_id__start,
                                     _termination_range__a2_id__stop,
                                     _timeframe_start,
                                     _timeframe_end
                                     ;
            END IF;
        --
        -- Exception: ungültiger AG
        IF _termination_middle__a2_id IS NULL AND _a2_n__middle IS NOT NULL THEN
            RAISE EXCEPTION '_termination_middle__a2_id IS NULL for ABK % AG %', _ab_ix, _a2_n__middle;
        END IF;


        -- wenn Vorwärts terminieren und Packen, dann Vorschau terminieren vorwärts um frühesten Ende-Termin zu finden
        IF _packing THEN
            -- frühesten Endezeitpunkt ermitteln
            _date_start :=       max(tfw.ti_date_end)
                            FROM scheduling.abk__termination_execute__auto(
                                                   _ab_ix,
                                                   _a2_n__middle,
                                                   _date_start, -- timediff_adddays(_date_start::date, 3, true, true), -- Abweichungen bei Transportzeit am Wochenende vorwärts/rückwärts führt dazu, das es NICHT genau in den Slot passt.
                                                   false, --_write_to_disk,
                                                   'forward',
                                                   _range_years,
                                                   false, -- _AutoForwardOnPast                        bool    DEFAULT true,
                                                   _a2_n__start,
                                                   _a2_n__stop,
                                                   _current_date,
                                                   _dlz_terminiation,
                                                   _allow_overlap,
                                                   _allow_overlap__following_if_necessary,  -- hier kein OR, da unsere eigene Funktion rekursiv. OR nur an die darunterliegende Funktion
                                                   _resource_id_main_fix__clear,
                                                   _stack_depth => -1, -- wir fangen komplett von vorn an. Evtl Fragmente in der existing_rt werden NICHT benötigt!. Kennzeichen für Resource fixieren während vorwärts terminieren
                                                   _loglevel => _loglevel
                                       ) AS tfw; -- termination for ward


            RAISE NOTICE 'packing result in : datestart for backward: %', _date_start;
            RETURN QUERY SELECT *
                           FROM scheduling.abk__termination_execute__auto(
                                                   _ab_ix,
                                                   _a2_n__middle,
                                                   _date_start, -- timediff_adddays(_date_start::date, 3, true, true), -- Abweichungen bei Transportzeit am Wochenende vorwärts/rückwärts führt dazu, das es NICHT genau in den Slot passt.
                                                   _write_to_disk,
                                                   'backward',
                                                   _range_years,
                                                   false, -- _AutoForwardOnPast                        bool    DEFAULT true,
                                                   _a2_n__start,
                                                   _a2_n__stop,
                                                   _current_date,
                                                   _dlz_terminiation,
                                                   _allow_overlap,
                                                   _allow_overlap__following_if_necessary,  -- hier kein OR, da unsere eigene Funktion rekursiv. OR nur an die darunterliegende Funktion
                                                   _resource_id_main_fix__clear,
                                                   _stack_depth => 0, -- wir fangen komplett von vorn an. Evtl Fragmente in der existing_rt werden NICHT benötigt!
                                                   _loglevel => _loglevel
                                       );

            RETURN;
        END IF;

        -- Wir speichern die bestehenden übgriggebliebenen RT, welche bei AG einschränkungen erhalten bleiben (andere AG die nicht in die Grenzen fallen).
        -- Die Terminierungsfunktion gibt ja nur die AGs zurück, welche terminiert wurden. Für die vollständige ABK benötigen wir alle.
        -- Dadurch, das austerminiert wurde, was terminiert werden soll, ist hier nur noch der Rest in scheduling.resource_timeline
        IF _loglevel >= 4 THEN
               RAISE NOTICE 'tabk.ab2_groups__recursive__by__ab_ix__get(%), ENTER:%;', _ab_ix, clock_timestamp()::time;
        END IF;
        INSERT INTO existing_rt
            SELECT rt.ti_resource_id AS __resource_id,
                   rt.ti_a2_id       AS __ab2_id,
                   a2_ab_ix          AS __ab_ix,
                   rt.ti_date_start  AS __slotstartdate,
                   rt.ti_date_end    AS __slotenddate,
                   rt.ti_ta_kf       AS __slotfactor,
                   rt.ti_type        AS __type,
                   ksv__is_top_ksv__by__ks_abt AS __ksv__is_top_ksv,
                   false             AS __timeslot_terminated,
                   null::text        AS __stat,
                   null::text        AS __debughint
              FROM scheduling.resource_timeline rt
              JOIN ab2 ON a2_id = rt.ti_a2_id
              LEFT JOIN LATERAL scheduling.resource__translate__resource_id__to__ksvba__shorthand(rt.ti_resource_id) AS ksvba ON true
              LEFT JOIN LATERAL scheduling.ksv__is_top_ksv__by__ks_abt(ksb_ks_abt) ON true
             WHERE rt.ti_a2_id IN ( -- alle ab2 einfügen
                                    SELECT a2_id
                                      FROM ab2
                                     WHERE a2_ab_ix = ANY( array_append( (SELECT array_agg(a2_ab_ix) FROM ab2 WHERE a2_id IN ( SELECT a2_id_to FROM tabk.ab2_groups__recursive__by__ab_ix__get(_ab_ix) ) ), _ab_ix ) ) --ABK durch Verkettungen! ODER direkter ABK-Index
                                  )
             ORDER BY rt.ti_date_start;

        IF _loglevel >= 4 THEN
               RAISE NOTICE 'tabk.ab2_groups__recursive__by__ab_ix__get(%), ENTER:%;', _ab_ix, clock_timestamp()::time;
        END IF;

        <<_following_if_necessary>> -- Sprungmarke, wird aber initial auch immer aufgerufen und dann je nachdem bei Folge-bei-Bedarf
        LOOP

            termination_successfull := false; -- wird true gesetzt, wenn erfolgreich


            -- !!!!!!!!!!!!!!!!!!!!!!!!!!! AUSTERMINIEREN !!!!!!!!!!!!!!! ACHTUNG, auch bei write_to_disk false!?!?!?!?! 

            RAISE NOTICE 'scheduler__abk__termination_execute__auto<<_following_if_necessary>>: scheduling.abk__termination_clear__from_to__a2_n(%, %, %, %);', _ab_ix, _a2_n__start, _a2_n__stop, _resource_id_main_fix__clear;
            PERFORM scheduling.abk__termination_clear__from_to__a2_n(_ab_ix, _a2_n__start, _a2_n__stop, _resource_id_main_fix__clear, _ab2_groups__recursive => false);

            -- alle ab2_groups dieser ABK. Die werden neu terminiert. Sonst liegen die uns zB auch selbst im Weg!
            -- das steht im LOOP, da bei ***Folge bei Bedarf*** auch wieder Gruppen anhängig sein könnten!.
            PERFORM scheduling.abk__termination_clear(_a2_ids => a2_id_to__arr, _resource_id_main_fix__Reset => _resource_id_main_fix__clear)
               FROM (SELECT array_agg(a2_id_chain) AS a2_id_to__arr
                       FROM (SELECT coalesce(a2_id_chain, a2_id) AS a2_id_chain
                               FROM ab2 LEFT JOIN tabk.ab2_groups__recursive__by__a2_id__get( a2_id ) ON true
                              WHERE a2_ab_ix = _ab_ix
                                AND a2_n BETWEEN coalesce(_a2_n__start, 0) AND coalesce(nullif(_a2_n__stop, 0), 9999999999)
                             ) AS arr
                      WHERE arr.a2_id_chain
                        NOT IN (SELECT __ab2_id
                                  FROM existing_rt
                                 WHERE __timeslot_terminated
                                )
                      ) AS sub;


            BEGIN -- scheduling.resource_timeline__abk_ab2__termination__grouped(

              debughint        :=  concat_ws(';', debughint, 'abk_ab2__termination__grouped:', _ab_ix, _termination_range__a2_id__start, _termination_range__a2_id__stop);
              s                := debughint;

              FOR r IN SELECT resource_timeline__abk_ab2__termination__grouped.*,
                              a2_ab_ix,
                              ksv__is_top_ksv__by__ks_abt
                         FROM scheduling.resource_timeline__abk_ab2__termination__grouped(
                                                   _abk_ix                                 => _ab_ix
                                                  ,_timeframe_start                        => _timeframe_start
                                                  ,_timeframe_end                          => _timeframe_end
                                                  ,_write_to_disk                          => _write_to_disk
                                                  ,_direction                              => _forward__backward__middle__null_auto
                                                  ,_scenario                               => NULL
                                                  ,_checkBlockedTimes                      => NOT _dlz_terminiation
                                                  ,_allow_overlap                          => _allow_overlap OR (_allow_overlap__following_if_necessary)
                                                  ,_termination_start_time                 => _termination_start__middle
                                                  ,_termination_start_ab2_id               => _termination_middle__a2_id
                                                  ,_termination_range_ab2_id_start         => _termination_range__a2_id__start
                                                  ,_termination_range_ab2_id_end           => _termination_range__a2_id__stop
                                                  ,_resource_id_main_fix__set              => _stack_depth = -1 -- Während Suche nach Enddatum auch Abrbeitsplatzressourcen fixieren. -1 ist bei Forwärts für Packen. Damit wird für das folgende Rückwärtsterminieren fixiert und keine Alternativen mehr!
                                                  ,_loglevel                               => _loglevel
                                     )
                         JOIN ab2 ON a2_id = resource_timeline__abk_ab2__termination__grouped.__ab2_id
                         LEFT JOIN LATERAL scheduling.resource__translate__resource_id__to__ksvba__shorthand(__resource_id) AS ksvba ON true
                         LEFT JOIN LATERAL scheduling.ksv__is_top_ksv__by__ks_abt(ksb_ks_abt) ON true
                        -- WHERE ksv__is_top_ksv__by__ks_abt IS false
              LOOP

                   termination_successfull := true;

                   ti_resource_id      := r.__resource_id;
                   ti_a2_id            := r.__ab2_id;
                   ti_date_start       := r.__slotstartdate;
                   ti_date_end         := r.__slotenddate;
                   slotfactor          := r.__slotfactor;
                   ti_type             := r.__type;
                   ksv__is_top_ksv     := r.ksv__is_top_ksv__by__ks_abt;
                   stat                := TSystem.ENUM_SetValue(stat, r.__stat);
                   debughint           := concat_ws('=>', s, r.__debughint);
                   timeslot_terminated := true; -- siehe Kommentierung Variable (Return Variable im nächsten Loop)
                   --
                   RETURN NEXT;
                   -- wir merken uns den temrinierten Zustand in der Temp-Tabelle, um im Anschluss prüfen zu können welche AGs Gruppenbezüge haben!
                   INSERT INTO existing_rt
                               (__resource_id,
                                __ab2_id,
                                __ab_ix,
                                __slotstartdate,
                                __slotenddate,
                                __slotfactor,
                                __type,
                                __ksv__is_top_ksv,
                                __timeslot_terminated,
                                __stat,
                                __debughint
                                )
                        VALUES (r.__resource_id,
                                r.__ab2_id,
                                r.a2_ab_ix,
                                r.__slotstartdate,
                                r.__slotenddate,
                                r.__slotfactor,
                                r.__type,
                                r.ksv__is_top_ksv__by__ks_abt,
                                true,
                                stat,
                                debughint
                                );

                  -- durch DLZ Terminierung könnte jetzt ein AG terminiert werden, welcher zuvor NICHT terminiert war. Da DLZ diesen NICHT austerminiert hatte, steht er als unterminiert in existing_rt, wo er jetzt als Terminiert hinzu kommt
                  DELETE FROM existing_rt WHERE __ab2_id = r.__ab2_id AND NOT __timeslot_terminated;

              END LOOP;


            EXCEPTION
               WHEN others THEN
                   -- bei Rückwärtsterminieren in Fehler gelaufen (Wahrscheinlich Vergangenheit, TODO: richtige Fehlermeldung für den Zustand)
                   IF _forward__backward__middle__null_auto = 'backward' AND _AutoForwardOnPast THEN
                      -- Fehler abfangen. Unten wird dann nochmal vorwärts terminiert.
                      RAISE WARNING '_forward__backward__middle__null_auto = backward AND _AutoForwardOnPast: %', SQLERRM;

                      -- wir Terminieren rückwärts, hatte kein Ergebnis => Vorwärts terminieren
                      RETURN QUERY SELECT * FROM scheduling.abk__termination_execute__auto(
                                       _ab_ix,
                                       _a2_n__middle,
                                       current_date, -- timediff_adddays(_date_start::date, 3, true, true), -- Abweichungen bei Transportzeit am Wochenende vorwärts/rückwärts führt dazu, das es NICHT genau in den Slot passt.
                                       _write_to_disk,
                                       'forward',
                                       _range_years,
                                       false, -- _AutoForwardOnPast                        bool    DEFAULT true,
                                       _a2_n__start,
                                       _a2_n__stop,
                                       _current_date,
                                       _dlz_terminiation,
                                       _allow_overlap, -- hier kein OR, da unsere eigene Funktion rekursiv. OR nur an die darunterliegende Funktion
                                       _allow_overlap__following_if_necessary,
                                       _resource_id_main_fix__clear,
                                       _stack_depth => 0, -- wir fangen komplett von vorn an. Evtl Fragmente in der existing_rt werden NICHT benötigt!
                                       _loglevel => _loglevel
                           );

                      RETURN;
                   ELSE
                      RAISE;
                   END IF;
            END;


            -- WENN "Vorwärtsterminieren und folge AGs bei Bedarf weiterschieben", prüfe Folge AG
            -- WENN Folge AG Mist, dann Terminiere diesen aus, nimm diesen als neue Grenzen und DLZ Terminierung AN!
            -- Zurück zum LOOP Start und den folgenden terminieren!

            _termination_middle__a2_id := null; -- Folge bei Bedarf nun nur noch. Da gibt es kein Mittelpunkt mehr!
            _termination_start__middle := null;


            IF (_stack_depth = 0) THEN -- _following_if_necessary

                RAISE NOTICE '_following_if_necessary already done: _following_ab2_arr__done:%', _following_ab2_arr__done;

                -- FolgeAG bei Bedarf: alle terminierten AGs prüfen
                IF _allow_overlap__following_if_necessary  THEN
                    FOR r IN SELECT __ab2_id 
                               FROM existing_rt
                              WHERE __timeslot_terminated
                                AND NOT __ksv__is_top_ksv
                                AND NOT TSystem.ENUM_ContainsValue(__stat, '_following_ab2__middle')
                              GROUP BY __ab2_id
                              ORDER BY min(__slotstartdate)
                    LOOP
                        -- Endless Loop: wir kommen pro FolgeAG hier wieder an. Daher müssen wir die bereits betrachteten ausschliessen!
                        IF        _following_ab2_arr__done IS null
                           OR NOT r.__ab2_id = ANY( _following_ab2_arr__done )
                        THEN
                          _following_ab2_arr := _following_ab2_arr || r.__ab2_id;
                        END IF;
                    END LOOP;
                END IF;

                <<_following_ab2_arr__loop>>
                LOOP

                    RAISE NOTICE '_following_if_necessary BEFORE: _stack_depth:%, _termination_range__a2_id__start:%, _following_ab2_arr=%', _stack_depth, _termination_range__a2_id__start, _following_ab2_arr;

                    debughint        := '_following_ab2_arr__loop:' || _following_ab2_arr::varchar;
                    stat             := TSystem.ENUM_SetValue(stat, '_following_ab2_arr__loop');

                    IF  (array_length(_following_ab2_arr, 1) > 0) /*_allow_overlap__following_if_necessary*/ THEN

                        -- vom letzten nach oben. Im Array sind die terminierten AGs, welche durch eine Gruppe terminiert wurden. Deren Folge-AGs könnten nun noch zu terminieren sein!
                        _termination_range__a2_id__start := _following_ab2_arr[1];

                        -- Das Element, welches wir jetzt bearbeiten, entfernen!
                        _following_ab2_arr := array_remove(_following_ab2_arr, _termination_range__a2_id__start);
                        _following_ab2_arr__done := _following_ab2_arr__done || _termination_range__a2_id__start; -- = _following_ab2_arr

                        -- Forwärts

                        -- Folge AG dieses AG finden, welcher bei Bedarf dann terminiert wird
                        SELECT a2_id AS a2_id__next,
                               a2_ab_ix,
                               a2_n  AS a2_n__next,
                               a2_at,
                               a2w_resource_id_main_terminated
                          INTO r
                          FROM scheduling.ab2__next__terminated__get(_termination_range__a2_id__start) AS nextab2 -- nächster terminierbarer AG in dieser ABK
                          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id
                        ;

                        _ab_ix := r.a2_ab_ix;

                        -- dieser Folger ist bereits terminiert, zB dadurch - das er an einer Gruppe hing. (220->320 [Folge wäre 330], 230 -> 330 [Somit ist 330 hier terminiert])
                        IF EXISTS (SELECT true FROM existing_rt WHERE __timeslot_terminated AND NOT __ksv__is_top_ksv AND __ab2_id = r.a2_id__next) THEN
                           RAISE NOTICE '_following_if_necessary: already terminated: NEXT => abix: %, a2_n__next:%, a2_id__next: %, a2_at__next__current: %, _following_ab2_arr=%', _ab_ix, r.a2_n__next, r.a2_id__next, r.a2_at, _following_ab2_arr;
                           CONTINUE _following_ab2_arr__loop; --loop
                        END IF;

                        -- Ende-Datum der Resource des zu terminierenden AGs bereits terminiert / verschoben. Wenn der NICHT terminiert war, haben wir keine terminierte Resource durch diesen Vorgang in existing_rt

                        -- Max terminiert auf Resourcen meiner ABK. Ohne INFO Meiner Resource, kann nur Max gehen da vollkommen unklar welcher Vorbezug besteht in welcher Ebene
                        _result_within_abk      := (SELECT max(__slotenddate) FROM existing_rt WHERE __timeslot_terminated AND NOT __ksv__is_top_ksv AND __ab_ix = r.a2_ab_ix);
                        -- mein Folge AG liegt auf einer anderen Resouce. Somit ist der Termin max() der auf dieser Resource terminierten AGs durch diese Terminierung. Bei Auswärtsresourcen NULL, somit bleibt er auf max der eigenen ABK und terminiert auswärts ggf parallel
                        _result_within_resource := (SELECT max(__slotenddate) FROM existing_rt WHERE __timeslot_terminated AND NOT __ksv__is_top_ksv AND __resource_id = r.a2w_resource_id_main_terminated AND NOT scheduling.resource__is_auswaerts( __resource_id ));
                        -- wurde auf der Resource nichts durch diese ABK berührt, dann Ende aus allen (Vorgänger??) !
                        _result_within_all      := (SELECT max(__slotenddate) FROM existing_rt WHERE __timeslot_terminated AND NOT __ksv__is_top_ksv); -- NOT scheduling.resource__is_auswaerts( __resource_id )

                        max_ti_date_end := coalesce( greatest( _result_within_abk
                                                              ,_result_within_resource
                                                              )
                                                     ,_result_within_all
                                                   );

                        RAISE NOTICE '_following_if_necessary RUN: a2_id->%, NEXT => abix: %, a2_n__next:%, a2_id__next: %, a2_at__next__current: %, max_ti_date_end: %; _stack_depth:%, _following_ab2_arr=%', _termination_range__a2_id__start, _ab_ix, r.a2_n__next, r.a2_id__next, r.a2_at, max_ti_date_end, _stack_depth, _following_ab2_arr;

                        RAISE NOTICE '_result_within_abk: %, %',       r.a2_ab_ix, _result_within_abk;
                        RAISE NOTICE '_result_within_resource: %, %',  r.a2w_resource_id_main_terminated, _result_within_resource;
                        RAISE NOTICE '_result_within_all: %',          _result_within_all;


                        IF r.a2_id__next IS NOT null
                            -- der Folge AG wird überlappt, oder er ist gar nicht terminiert. Terminieren! ACHTUNG: wenn er NICHT terminiert ist, wissen wir die Resource NICHT!
                            AND (max_ti_date_end::date >= r.a2_at::date OR r.a2_at IS null)
                        THEN

                            _timeframe_start := max_ti_date_end;

                            -- wenn wir auf der gleichen Resource bleiben, braucht es keine 1 Tage!
                            IF (SELECT coalesce(a2w_resource_id_main_fix::varchar, a2_ks)
                                  FROM ab2 LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1 -- SplitAGs;
                                 WHERE a2w_a2_id = _termination_range__a2_id__start
                                )
                                IS DISTINCT FROM
                                (SELECT coalesce(a2w_resource_id_main_fix::varchar, a2_ks)
                                   FROM ab2 LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1 -- SplitAGs;
                                  WHERE a2w_a2_id = r.a2_id__next
                                )
                            THEN
                               _timeframe_start := timediff_adddays(_timeframe_start::date, 1, true, true)::date; -- https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112#teststep-19818
                                                                                                                  -- https://ci.prodat-sql.de/sources/tests/suite/9/runner/1112#teststep-17010
                            END IF;

                            DELETE FROM existing_rt WHERE __ab2_id = r.a2_id__next;

                            _termination_range__a2_id__start := r.a2_id__next;
                            _termination_range__a2_id__stop  := _termination_range__a2_id__start;
                            _a2_n__start := r.a2_n__next;
                            _a2_n__stop  := _a2_n__start;

                            _dlz_terminiation := true; -- !!!! TODO -> das muss NICHT mehr sein!

                            -- Wir werden jetzt terminiert. Somit ist unser Nachfolger im nächsten Schritt zu prüfen
                            IF r.a2_id__next IS NOT null THEN
                               _following_ab2_arr := _following_ab2_arr || r.a2_id__next;
                            END IF;

                            CONTINUE _following_if_necessary; --loop => die Parameter sind neu gesetzt, diesen FolgeAG terminieren wird jetzt
                        ELSE
                            -- hier kommen wir an, wenn der AG im Array selbst keinen terminierbaren FolgeAG mehr hat. Dann ist r.a2_id NULL und es passiert kein Continue.
                            -- Somit bearbeiten wir das nächste Element im Array oder gehen raus, wenn der Array leer ist.
                            CONTINUE _following_ab2_arr__loop; -- loop über alle terminierten AGs und Prüfung ob Folge terminiert werden muss!
                        END IF;

                    END IF;

                    EXIT; -- WHEN  (array_length(_following_ab2_arr, 1) = 0);

                END LOOP; -- _following_ab2_arr__loop
            ELSE

            END IF; -- (_stack_depth = 0) THEN

            EXIT;

            RAISE EXCEPTION '_following_if_nescessary -> EXIT';

        END LOOP;

        IF termination_successfull AND (_stack_depth = 0) THEN -- RETURN nicht terminiertes. Terminiere Gruppen AGs

           -- RETURN existing_rt WHERE NOT terminated: durch teilweises Terminieren (ab AG) bleiben die vorherigen Parts stehen und werden nicht austerminiert, diese zurückgeben
               -- diese zeigen wir jetzt hier mit an
               -- durch die zwischenzeitliche Terminierung kamen evtl neue hinzu, diese wurden oben bereits zurückgegeben (durch die funktion selbst)
               -- wir geben nur die temp gespeicherten zurück, die vorher schon da waren
               -- Alles was nicht terminiert wird, eintragen (timeslot_terminated = false), terminieren, was terminiert ist, eintragen. Wird was terminiert, was bisher "nicht zu terminieren" war (eingangsparameter und dann doch > notwendige bei Bedarf), wird dies timeslot_terminated => true und vorher gelöscht.

               FOR r IN SELECT *
                          FROM existing_rt                         
                         WHERE NOT __timeslot_terminated
               LOOP
                   ti_resource_id        := r.__resource_id;
                   ti_a2_id              := r.__ab2_id;
                   ti_date_start         := r.__slotstartdate;
                   ti_date_end           := r.__slotenddate;
                   slotfactor            := r.__slotfactor;
                   ti_type               := r.__type;
                   ksv__is_top_ksv       := r.__ksv__is_top_ksv;
                   timeslot_terminated   := r.__timeslot_terminated; -- siehe Kommentierung Variable

                   stat                  := r.__stat;
                   debughint             := 'lower loop:NOT __timeslot_terminated';
                   RETURN NEXT;
               END LOOP;

           --

        END IF;


        IF (_stack_depth = 0) THEN
           PERFORM enablebedarfberech();
           PERFORM do_artikel_bedarf();
        END IF;


        RETURN;
        --
    END $$ LANGUAGE plpgsql;